%   Copyright  2020 University of Extremadura (UEx)
%
% kNNEstimation
%  Input:
%   samples: Fingerprinting database RSSI
%   query: RSSI vector
%   positions: Fingerprining database positioning
%   k: Parameter in the k-NN algorithm
%
%  Output:
%   prediction: Predicted position for que query vector in real space
%   zE: 
% -----------------------------------------

function [prediction, ks] = kNNEstimation(samples, query, positions, k)

   
    %{
    [samplRows, ~] = size(samples);
    [queryRows,~] = size(query);

    prediction = zeros(queryRows, 3);
    ks = zeros(queryRows, 1);
    
    if (k > samplRows)
        k = samplRows;  % First k adjustment
    end

    samplesNans = isnan(samples);
    
    % For each query element
    for i = (1:queryRows)
        qv = query(i,:);
        qvNans = isnan(qv);

        if(sum(~qvNans) == 0)
            prediction(i,:) = nan;
        else
            anyNans = samplesNans | qvNans;
            dists = sqrt(sum((samples - qv).^2,2,'omitnan'));
            dists(sum(~anyNans,2)==0) = nan;   % address row with all nans 
            tt = [dists,sum(~anyNans,2)]; % for tie cases, to choose those with less nans
            [~, indices] = sortrows(tt, 'ascend', 'MissingPlacement', 'last');

            IDX = indices(1:k);
            ks(i) = mean(tt(IDX,2));
            prediction(i,:) = mean(positions(IDX,:),1);
        end
    end

    %}
        new_distancia_euclidea_penalizada(r,t,Ap)

end

